appModule.directive("pickDate", ['$translate',"utils", function (translate,utils) {
    return {
        template: '<div class="timesWrapper"><span class="timetitle rightLine" ng-bind="desc"></span><div class="start-time"></div>',
        restrict: "E",
        scope: {
            desc: "=",
            date: "="
        },
        link: function ($scope, element) {
            if(!$scope.date){
                $scope.date = Date.now();
            }
            String.prototype.repeat = function (data) {
                return this.replace(/\{\w+\}/g, function (str) {
                    var prop = str.replace(/\{|\}/g, '');
                    return data[prop] || '';
                });
            };

            String.prototype.toDate = function () {
                var dt = new Date(),
                    dot = this.replace(/\d/g, '').charAt(0),
                    arr = this.split(dot);

                dt.setFullYear(arr[0]);
                dt.setMonth(arr[1] - 1);
                dt.setDate(arr[2]);
                return dt;
            };

            Date.prototype.format = function (exp) {
                var y = this.getFullYear(),
                    m = this.getMonth() + 1,
                    d = this.getDate();

                return exp.replace('yyyy', y).replace('mm', m < 10 ? "0" + m : m).replace('dd', d < 10 ? "0" + d : d);
            };

            Date.prototype.formatHM = function (exp) {
                var h = this.getHours(),
                    m = this.getMinutes();
                return exp.replace('hhh', h <= 9 ? '0' + h : h).replace('mm', m < 10 ? "0" + m : m);
            };

            Date.prototype.isSame = function (y, m, d) {
                if (isDate(y)) {
                    var dt = y;
                    y = dt.getFullYear();
                    m = dt.getMonth() + 1;
                    d = dt.getDate();
                }
                return this.getFullYear() === y && this.getMonth() + 1 === m && this.getDate() === d;
            };

            Date.prototype.add = function (n) {
                this.setDate(this.getDate() + n);
            };

            Date.prototype.minus = function (n) {
                this.setDate(this.getDate() - n);
            };

            Date.prototype.clearTime = function () {
                this.setHours(0);
                this.setSeconds(0);
                this.setMinutes(0);
                this.setMilliseconds(0);
                return this;
            };

            Date.isLeap = function (y) {
                return (y % 100 !== 0 && y % 4 === 0) || (y % 400 === 0);
            };
            Date.getDaysNum = function (y, m) {
                var num = 31;

                switch (m) {
                    case 2:
                        num = this.isLeap(y) ? 29 : 28;
                        break;
                    case 4:
                    case 6:
                    case 9:
                    case 11:
                        num = 30;
                        break;
                }
                return num;
            };

            Date.getSiblingsMonth = function (y, m, n) {
                var d = new Date(y, m - 1);
                d.setMonth(m - 1 + n);
                return {
                    y: d.getFullYear(),
                    m: d.getMonth() + 1
                };
            };

            Date.getPrevMonth = function (y, m, n) {
                return this.getSiblingsMonth(y, m, 0 - (n || 1));
            };

            Date.getNextMonth = function (y, m, n) {
                return this.getSiblingsMonth(y, m, n || 1);
            };

            Date.getCurrentMonth = function (y, m, day) {
                //return this.getSiblingsMonth(y, m, 0);
                var d = new Date(y, m - 1, day || 0);
                d.setMonth(m - 1);
                return {
                    y: d.getFullYear(),
                    m: d.getMonth() + 1
                };
            };

            Date.tryParse = function (obj) {
                if (!obj) {
                    return obj;
                }
                return isDate(obj) ? obj : obj.toDate();
            };

            var defaults = {
                    width: 158,
                    height: 158,
                    zIndex: 999,
                    // 偏移位置，可设正负值
                    // trigger 设置时生效
                    offset: [0, 3],

                    // 自定义类，用于重写样式
                    customClass: '',

                    // 显示视图
                    // 可选：date, month
                    view: 'date',
                    // 默认日期为当前日期
                    date: new Date(),
                    format: 'yyyy/mm/dd',
                    HMFormat: 'hhh:mm',
                    // 一周的第一天,0表示周日，依次类推
                    startWeek: 0,
                    // 星期格式
                    weekArray: [translate.instant('pickDate.dayArray.sunday'), translate.instant('pickDate.dayArray.monday'), translate.instant('pickDate.dayArray.tuesday'), translate.instant('pickDate.dayArray.wednesday'), translate.instant('pickDate.dayArray.thursday'), translate.instant('pickDate.dayArray.friday'), translate.instant('pickDate.dayArray.saturday')],

                    // 设置选择范围
                    // 格式：[开始日期, 结束日期]
                    // 开始日期为空，则无上限；结束日期为空，则无下限
                    // 如设置2015年11月23日以前不可选：[new Date(), null] or ['2015/11/23']
                    selectedRang: null,

                    // 日期关联数据 [{ date: string, value: object }, ... ]
                    // 日期格式与 format 一致
                    // 如 [ {date: '2015/11/23', value: ''} ]
                    data: null,

                    // 展示关联数据
                    // 格式化参数：{m}视图，{d}日期，{v}value
                    // 设置 false 表示不显示
                    label: '{d}\n{v}',

                    // 切换字符
                    prev: '&lt;',
                    next: '&gt;',

                    // 切换视图
                    // 参数：view, y, m
                    viewChange: $.noop,

                    // view: 视图
                    // date: 不同视图返回不同的值
                    // value: 日期关联数据
                    onSelected: function (view, date, value) {
                        // body...
                    },
                    // 参数同上
                    onMouseEnter: $.noop,

                    onClose: $.noop,
                    onValueChange: function (date) {
                        //if date is null,do nothing
                    }

                },

            // static variable

                ACTION_NAMESPACE = 'data-pickAdate-',

                DISPLAY_VD = '[' + ACTION_NAMESPACE + 'display-date]',
                DISPLAY_VM = '[' + ACTION_NAMESPACE + 'display-month]',

                ARROW_DATE = '[' + ACTION_NAMESPACE + 'arrow-date]',
                ARROW_MONTH = '[' + ACTION_NAMESPACE + 'arrow-month]',

                ITEM_DAY = ACTION_NAMESPACE + 'day',
                ITEM_MONTH = ACTION_NAMESPACE + 'month',

                DISABLED = 'disabled',
                MARK_DATA = 'markData',

                VIEW_CLASS = {
                    date: 'pickAdate-d',
                    month: 'pickAdate-m'
                },

                OLD_DAY_CLASS = 'old',
                NEW_DAY_CLASS = 'new',
                TODAY_CLASS = 'now',
                SELECT_CLASS = 'selected',
                MARK_DAY_HTML = '<i class="dot"></i>',
                DATE_DIS_TPL = '{year}' + translate.instant('pickDate.year') + '<span class="m">{month}' + translate.instant('pickDate.month') + '</span>',

                ITEM_STYLE = 'style="width:{w}px;height:{h}px;line-height:{h}px"',
                WEEK_ITEM_TPL = '<li ' + ITEM_STYLE + '>{wk}</li>',
                DAY_ITEM_TPL = '<li ' + ITEM_STYLE + ' class="{class}" {action}>{value}</li>',
                MONTH_ITEM_TPL = '<li ' + ITEM_STYLE + ' ' + ITEM_MONTH + '>{m}' + translate.instant('pickDate.month') + '</li>',

                TEMPLATE = [
                    '<div class="pickAdate-views">',
                    '<div class="view view-date">',
                    '<div class="pickAdate-hd">',
                    '<a href="javascript:;" data-pickAdate-display-date class="pickAdate-display">',
                    '{yyyy}<span class="m">{mm}</span>',
                    '</a>',
                    '<div class="pickAdate-arrow">',
                    '<span class="prev" title="' + translate.instant('pickDate.lastMonth') + '" data-pickAdate-arrow-date></span>',
                    '<span class="current" title="' + translate.instant('pickDate.currentMonth') + '" data-pickAdate-arrow-date></span>',
                    '<span class="next" title="' + translate.instant('pickDate.nextMonth') + '" data-pickAdate-arrow-date></span>',
                    '</div>',
                    '</div>',
                    '<div class="pickAdate-ct">',
                    '<ol class="week">{week}</ol>',
                    '<ul class="date-items"></ul>',
                    '</div>',
                    '</div>',
                    '<div class="view view-month">',
                    '<div class="pickAdate-hd">',
                    '<a href="javascript:;" data-pickAdate-display-month class="pickAdate-display">{yyyy}</a>',
                    '<div class="pickAdate-arrow">',
                    '				<span class="prev" title="' + translate.instant('pickDate.lastYear') + '" data-pickAdate-arrow-month></span>',
                    '<span class="next" title="' + translate.instant('pickDate.nextYear') + '" data-pickAdate-arrow-month></span>',
                    '</div>',
                    '</div>',
                    '<ol class="pickAdate-ct month-items">{month}</ol>',
                    '</div>',
                    '</div>',
                    '<div class="pickAdate-label"><p>HelloWorld</p><i></i></div>'
                ],

                OS = Object.prototype.toString;

            // utils
            function isDate(obj) {
                return OS.call(obj) === '[object Date]';
            }

            function isString(obj) {
                return OS.call(obj) === '[object String]';
            }

            function getClass(el) {
                return el.getAttribute('class') || el.getAttribute('className');
            }

            function calcElementPosition($element, $targetTag) {
                var top = $targetTag.offset().top + $targetTag.height();
                var left = $targetTag.offset().left;
                var elementHeight = $element.outerHeight();
                if (elementHeight + top + defaults.offset[1] > $(window).height()) {
                    top = $targetTag.offset().top - defaults.offset[1] - elementHeight;
                }

                $element.css({
                    top: top,
                    left: left
                });
            }

            function pickDate(element, hasWeekDay, hasTimeInput, onValueChange) {
                this.$parent = $(element);
                this.options = $.extend({}, defaults);
                this.onValueChange = onValueChange;

                this.$inputBox = ['<input type="text" placeholder="" class="YMDInputBox"/>'];
                if (hasWeekDay) {
                    this.$inputBox.push('<span class="week-span">(' + translate.instant('pickDate.weekArray.thursday') + ')</span>');
                }

                if (hasTimeInput) {
                    this.$inputBox.push('<input type="text" id="HMInputId" placeholder=""  class="HMInputBox"/>');
                } else {
                    this.$inputBox.push('<input type="text" id="HMInputId"  placeholder=""  class="HMInputBox hide"/>');
                }

                //input box
                this.$inputTemplate = $('<div class="pickAdate-inputBox">');
                this.$inputTemplate.append($(this.$inputBox.join('')));
                this.$parent.append(this.$inputTemplate);
                this.$YMDInput = $('.YMDInputBox', this.$inputTemplate);
                this.$HMInput = $('.HMInputBox', this.$inputTemplate);
                this.$weekDay = $('.week-span', this.$inputTemplate);
                //timelist
                this.$timeList = $('<div class="pickAdate-timeList"/>');
                this.$parent.append(this.$timeList);
                //calendarBox
                this.$element = $('<div class="pickAdate-inner"/>');
                this.$element.addClass('pickAdate ' + this.options.customClass);
                this.$parent.append(this.$element);

                this.width = this.options.width;
                this.height = this.options.height;
                this.date = this.options.date;
                this.selectedRang = this.options.selectedRang;
                this.data = this.options.data;
                this.init();
                if (hasTimeInput) {
                    new timeChooseBox('HMInputId', {
                        onclick: this.HMInputClick,
                        onkeypress: this.HMInputOnKeyEvent,
                        self:this
                    });
                }

            }

            $.extend(pickDate.prototype, {
                init: function () {
                    this.fillStatic();
                    this.resize();
                    this.render();
                    this.view = this.options.view;
                    this.setView(this.view);
                    this.event();
                },
                getDayAction: function (day) {
                    var action = ITEM_DAY;
                    if (this.selectedRang) {
                        var start = Date.tryParse(this.selectedRang[0]),
                            end = Date.tryParse(this.selectedRang[1]);

                        if ((start && day < start.clearTime()) || (end && day > end.clearTime())) {
                            action = DISABLED;
                        }
                    }
                    return action;
                },
                getDayData: function (day) {
                    var ret, data = this.data;
                    if (data) {

                        for (var i = 0, len = data.length; i < len; i++) {
                            var item = data[i];

                            if (day.isSame(item.date.toDate())) {
                                ret = item.value;
                            }
                        }
                    }
                    return ret;
                },
                getDayItem: function (y, m, d, f) {
                    var dt = this.date,
                        idt = new Date(y, m - 1, d),
                        data = {
                            w: this.width / 7,
                            h: this.height / 7,
                            value: d
                        },
                        markData,
                        $item;

                    var selected = dt.isSame(y, m, d) ? SELECT_CLASS : '';
                    if (f === 1) {
                        data['class'] = OLD_DAY_CLASS;
                    } else if (f === 3) {
                        data['class'] = NEW_DAY_CLASS;
                    } else {
                        data['class'] = '';
                    }

                    if (dt.isSame(y, m, d)) {
                        data['class'] += ' ' + TODAY_CLASS;
                    }

                    data.action = this.getDayAction(idt);
                    markData = this.getDayData(idt);

                    $item = $(DAY_ITEM_TPL.repeat(data));

                    if (markData) {
                        $item.data(MARK_DATA, markData);
                        $item.html(d + MARK_DAY_HTML);
                    }

                    $item.attr('date', y + '_' + m + '_' + d);

                    return $item;
                },
                getDaysHtml: function (y, m) {
                    var year, month, firstWeek, daysNum, prevM, prevDiff,
                        dt = this.date,
                        $days = $('<ol class="days"></ol>');

                    if (isDate(y)) {
                        year = y.getFullYear();
                        month = y.getMonth() + 1;
                    } else {
                        year = Number(y);
                        month = Number(m);
                    }

                    firstWeek = new Date(year, month - 1, 1).getDay() || 7;
                    prevDiff = firstWeek - this.options.startWeek;
                    daysNum = Date.getDaysNum(year, month);
                    prevM = Date.getPrevMonth(year, month);
                    //prevDaysNum = Date.getDaysNum(year, prevM.m);
                    var prevDaysNum = Date.getDaysNum(year, month);
                    var nextM = Date.getNextMonth(year, month);
                    // month flag
                    var PREV_FLAG = 1,
                        CURR_FLAG = 2,
                        NEXT_FLAG = 3,
                        count = 0;

                    for (var p = prevDaysNum - prevDiff + 1; p <= prevDaysNum; p++, count++) {
                        $days.append(this.getDayItem(prevM.y, prevM.m, p, PREV_FLAG));
                    }

                    for (var c = 1; c <= daysNum; c++, count++) {
                        $days.append(this.getDayItem(year, month, c, CURR_FLAG));
                    }

                    for (var n = 1, nl = 42 - count; n <= nl; n++) {

                        $days.append(this.getDayItem(nextM.y, nextM.m, n, NEXT_FLAG));
                    }

                    return $('<li></li>').width(this.options.width).append($days);
                },
                getWeekHtml: function () {
                    var week = [],
                        weekArray = this.options.weekArray,
                        start = this.options.startWeek,
                        len = weekArray.length,
                        w = this.width / 7,
                        h = this.height / 7;

                    for (var i = start; i < len; i++) {
                        week.push(WEEK_ITEM_TPL.repeat({
                            w: w,
                            h: h,
                            wk: weekArray[i]
                        }));
                    }

                    for (var j = 0; j < start; j++) {
                        week.push(WEEK_ITEM_TPL.repeat({
                            w: w,
                            h: h,
                            wk: weekArray[j]
                        }));
                    }

                    return week.join('');
                },
                getMonthHtml: function () {
                    var month = [],
                        w = this.width / 4,
                        h = this.height / 4,
                        i = 1;

                    for (; i < 13; i++) {
                        month.push(MONTH_ITEM_TPL.repeat({
                            w: w,
                            h: h,
                            m: i
                        }));
                    }

                    return month.join('');
                },
                setMonthAction: function (y) {
                    var m = this.date.getMonth() + 1;

                    this.$monthItems.children().removeClass(TODAY_CLASS);
                    if (y === this.date.getFullYear()) {
                        this.$monthItems.children().eq(m - 1).addClass(TODAY_CLASS);
                    }
                },
                fillStatic: function () {
                    var staticData = {
                        prev: this.options.prev,
                        next: this.options.next,
                        week: this.getWeekHtml(),
                        month: this.getMonthHtml()
                    };

                    this.$element.html(TEMPLATE.join('').repeat(staticData));
                },
                updateDisDate: function (y, m) {
                    this.$disDate.html(DATE_DIS_TPL.repeat({
                        year: y,
                        month: m
                    }));
                },
                updateDisMonth: function (y) {
                    this.$disMonth.html(y);
                },
                fillDateItems: function (y, m) {
                    var ma = [
                        Date.getPrevMonth(y, m), {
                            y: y,
                            m: m
                        },
                        Date.getNextMonth(y, m)
                    ];

                    this.$dateItems.html('');
                    for (var i = 0; i < 3; i++) {
                        var $item = this.getDaysHtml(ma[i].y, ma[i].m);
                        this.$dateItems.append($item);
                    }

                },
                hide: function (view, date, data) {
                    this.$YMDInput.val(date.format(this.options.format));
                    this.$weekDay.text('(' + this.getWeekDayStr(date) + ')');
                    this.onValueChange(this.getDate());
                    this.options.onClose.call(this, view, date, data);
                    this.$element.hide();
                },
                YMDelementShow: function (target) {
                    var date = this.getDate();
                    if (date != null) {
                        this.setDate(date);
                    }
                    calcElementPosition(this.$element, $(target));
                    this.$element.show();
                },
                YMDElementHide: function () {
                    this.$element.hide();
                },
                trigger: function () {
                    var _this = this,
                        post = _this.$YMDInput.offset(),
                        offs = _this.options.offset;
                    var top = (post.top + _this.$YMDInput.outerHeight() + offs[1]);

                    _this.$element.addClass('pickAdate-modal').css({
                        left: (post.left + offs[0]) + 'px',
                        top: (post.top + _this.$YMDInput.outerHeight() + offs[1]) + 'px',
                        zIndex: _this.options.zIndex
                    });
                    _this.$YMDInput.click(function () {
                        if (_this.$element.is(':hidden')) {
                            _this.YMDelementShow(this);
                        } else
                            _this.YMDElementHide();
                        this.setSelectionRange(0, $(this).val().length);
                    }).keypress(function (e) {
                        var code = (e.keyCode ? e.keyCode : e.which);
                        //0-9 /
                        return $(this).val().length < 10 && (code >= 48 && code <= 57 || code == 47);// || code == 47
                    }).keyup(function (e) {
                        if (!_this.$element.is(':hidden'))
                            _this.$element.hide();
                    });
                    $(document).click(function (e) {
                        if (_this.$YMDInput[0] != e.target && !$.contains(_this.$element[0], e.target)) {
                            _this.$element.hide();
                        }
                        if (_this.$HMInput[0] != e.target && !$.contains(_this.$timeList[0], e.target)) {
                            _this.timeListHide();
                        }
                    });
                    $(window).on('resize', function () { //当页面大小发生变化时，隐藏日期和时间选择框
                        _this.$element.hide();
                        _this.timeListHide();
                    });
                },
                HMInputClick: function (value, selectionStart, selectionEnd, _self) {
                    _self.timeListHide();
                    var _tempsz = value.split(':');
                    if (selectionStart < 2)
                        _self.timelistShow(_tempsz[0], 'H', value, selectionStart, selectionEnd);
                    else
                        _self.timelistShow(_tempsz[1], '', value, selectionStart, selectionEnd);
                },
                HMInputOnKeyEvent: function (_self) {
                    if (!_self.$timeList.is(':hidden'))
                        _self.timeListHide();
                },
                timelistShow: function (time, type, value, startIndex, endIndex) {
                    var _lis = "<ol>", _this = this;
                    var len = type == "H" ? 24 : 60;
                    for (var i = 0; i < len; i++) {
                        if (parseInt(time) == i)
                            _lis += "<li class='timelistSelected'>" + (i < 10 ? "0" + i : i) + "</li>";
                        else
                            _lis += "<li>" + (i < 10 ? "0" + i : i) + "</li>";
                    }
                    _lis += "</ol>"
                    this.$timeList.append($(_lis));
                    this.$timeList.show();
                    //timeList position
                    var _offset = this.$HMInput.position();
                    calcElementPosition(this.$timeList, this.$HMInput);
                    this.$timeList.css("left", (parseInt(this.$timeList.css("left")) - 18) + "px");
                    var _ol = this.$timeList.find('ol');
                    var _top = 0;
                    if ($(".timelistSelected")) {
                        _top = $(".timelistSelected").position().top - 50;
                    }
                    _ol.animate({scrollTop: _top}, 300);
                    _ol.find('li').click(function (e) {
                        _this.timeListHide();
                        // console.log($(this).text());
                        // console.log(startIndex, endIndex);
                        value = value.substring(0, startIndex) + $(this).text() + value.substring(endIndex);
                        _this.$HMInput.val(value);
                        _this.onValueChange(_this.getDate());
                    });
                },
                timeListHide: function () {
                    this.$timeList.find('*').off();
                    this.$timeList.empty();
                    this.$timeList.hide();
                },
                render: function () {
                    this.$week = this.$element.find('.week');
                    this.$dateItems = this.$element.find('.date-items');
                    this.$monthItems = this.$element.find('.month-items');
                    this.$label = this.$element.find('.pickAdate-label');
                    this.$disDate = this.$element.find(DISPLAY_VD);
                    this.$disMonth = this.$element.find(DISPLAY_VM);

                    this.date = this.options.date;
                    this.$YMDInput.val(this.date.format(this.options.format));
                    this.$weekDay.text('(' + this.getWeekDayStr() + ')');
                    this.$HMInput.val(this.date.formatHM(this.options.HMFormat));

                    this.trigger();
                },
                setDate: function (date) {
                    if (date != null) {
                        this.date = date;
                        this.$YMDInput.val(this.date.format(this.options.format));
                        this.$weekDay.text('(' + this.getWeekDayStr() + ')');
                        this.$HMInput.val(this.date.formatHM(this.options.HMFormat));

                    } else {
                        this.date = new Date();
                        this.$YMDInput.val('');
                        this.$weekDay.text('');
                        this.$HMInput.val('');
                    }
                    var y = this.date.getFullYear(),
                        m = this.date.getMonth() + 1;
                    this.updateDisDate(y, m);
                    this.updateDisMonth(y);
                    this.fillDateItems(y, m);
                },

                getWeekDayStr: function (date) {
                    var weekDay = date ? date.getDay() : this.date.getDay();
                    var weekDayStr;
                    switch (weekDay) {
                        case 0:
                            weekDayStr = translate.instant('pickDate.weekArray.sunday');
                            break;
                        case 1:
                            weekDayStr = translate.instant('pickDate.weekArray.monday');
                            break;
                        case 2:
                            weekDayStr = translate.instant('pickDate.weekArray.tuesday');
                            break;
                        case 3:
                            weekDayStr = translate.instant('pickDate.weekArray.wednesday');
                            break;
                        case 4:
                            weekDayStr = translate.instant('pickDate.weekArray.thursday');
                            break;
                        case 5:
                            weekDayStr = translate.instant('pickDate.weekArray.friday');
                            break;
                        case 6:
                            weekDayStr = translate.instant('pickDate.weekArray.saturday');
                            break;
                    }
                    return weekDayStr;
                },
                getDate: function () {
                    return this.checkInputIsOk();
                },
                checkInputIsOk: function () {
                    var _ymdvalue = this.$YMDInput.val();
                    var _hmvalue = this.$HMInput.val();
                    var _ymdvaluesz = _ymdvalue.split('/');
                    var _hmvaluesz = _hmvalue ? _hmvalue.split(':') : null;
                    var _ymdvalueError = false;
                    var _hmvalueError = false;
                    //check YMDinput value  is error?
                    if (_ymdvalue.length < 8 || _ymdvaluesz.length != 3)
                        _ymdvalueError = true;
                    else {
                        var _y = parseInt(_ymdvaluesz[0]);
                        var _m = parseInt(_ymdvaluesz[1]);
                        var _d = parseInt(_ymdvaluesz[2]);
                        if (_y == "" || isNaN(_y)
                            || _m == "" || isNaN(_m)
                            || _d == "" || isNaN(_d))
                            _ymdvalueError = true;
                        else {
                            if (_y < 1)
                                _ymdvalueError = true;
                            else if (_m > 12 || _m < 1)
                                _ymdvalueError = true;
                            else {
                                var currentMonthMaxDay = new Date(_y, _m, 0).getDate();
                                if (_d > currentMonthMaxDay || _d < 1)
                                    _ymdvalueError = true;
                            }
                        }
                    }
                    if (_ymdvalueError) {
                        this.$YMDInput.addClass("inputError");
                        return null;
                    } else {
                        this.$YMDInput.hasClass("inputError")
                        this.$YMDInput.removeClass("inputError");
                    }
                    //check HMinput value is error?
                    if (_hmvaluesz) {
                        if (_hmvaluesz.length != 2 || _hmvalue.length < 3)
                            _hmvalueError = true;
                        else {
                            var _h = parseInt(_hmvaluesz[0]);
                            var _m = parseInt(_hmvaluesz[1]);

                            if (_h === "" || isNaN(_h)
                                || _m === "" || isNaN(_m))
                                _hmvalueError = true;
                            else {
                                if (_h < 0 || _h > 23)
                                    _hmvalueError = true;
                                else if (_m > 59 || _m < 0)
                                    _hmvalueError = true;
                            }
                        }
                        if (_hmvalueError) {
                            this.$HMInput.addClass("inputError");
                            return null;
                        } else {
                            this.$HMInput.hasClass("inputError")
                            this.$HMInput.removeClass("inputError");
                        }
                    }


                    return new Date(_ymdvaluesz[0], _ymdvaluesz[1] - 1, _ymdvaluesz[2], _hmvaluesz ? _hmvaluesz[0] : 0, _hmvaluesz ? _hmvaluesz[1] : 0);
                },
                setView: function (view) {
                    this.$element.removeClass(VIEW_CLASS.date + ' ' + VIEW_CLASS.month)
                        .addClass(VIEW_CLASS[view]);
                    this.view = view;
                },
                updateDateView: function (y, m, dirc, cb) {
                    m = m || this.date.getMonth() + 1;
                    var day = this.date.getDate();
                    var _this = this,
                        $dis = this.$dateItems,
                        exec = {
                            current: function () {
                                var time = new Date();
                                y = time.getFullYear();
                                day = time.getDate();
                                m = time.getMonth() + 1;
                                _this.updateDisDate(y, m);
                                _this.updateDisMonth(y);
                                _this.fillDateItems(y, m);
                                $('ol.days li.now').removeClass('now');
                                $('ol.days:eq(1) li[date="' + y + '_' + m + '_' + day + '"]').addClass('now');
                            },
                            prev: function () {
                                var pm = Date.getPrevMonth(y, m),
                                    ppm = Date.getPrevMonth(y, m, 2),
                                    $prevItem = _this.getDaysHtml(ppm.y, ppm.m);
                                m = pm.m;
                                y = pm.y;

                                $dis.animate({
                                    marginLeft: 0
                                }, 300, 'swing', function () {
                                    $dis.children(':last').remove();
                                    $dis.prepend($prevItem).css('margin-left', '-100%');

                                    $.isFunction(cb) && cb.call(_this);
                                });
                            },
                            next: function () {
                                var nm = Date.getNextMonth(y, m),
                                    nnm = Date.getNextMonth(y, m, 2),
                                    $nextItem = _this.getDaysHtml(nnm.y, nnm.m);

                                m = nm.m;
                                y = nm.y;

                                $dis.animate({
                                    marginLeft: '-200%'
                                }, 300, 'swing', function () {
                                    $dis.children(':first').remove();
                                    $dis.append($nextItem).css('margin-left', '-100%');

                                    $.isFunction(cb) && cb.call(_this);
                                });

                            }
                        };


                    if (dirc) {
                        exec[dirc]();
                    } else {
                        this.fillDateItems(y, m);
                    }

                    this.updateDisDate(y, m);

                    this.setView('date');

                    return {
                        y: y,
                        m: m,
                        d: day
                    };
                },
                updateMonthView: function (y) {
                    this.updateDisMonth(y);
                    this.setMonthAction(y);
                    this.setView('month');
                },
                getDisDateValue: function () {
                    var arr = this.$disDate.html().split(translate.instant('pickDate.year')),
                        y = Number(arr[0]),
                        m = Number(arr[1].match(/\d{1,2}/)[0]);

                    return [y, m];
                },
                selectedDay: function (d, type) {
                    var arr = this.getDisDateValue(),
                        y = arr[0],
                        m = arr[1],
                        toggleClass = function () {
                            this.$dateItems.children(':eq(1)')
                                .find('[' + ITEM_DAY + ']:not(.' + NEW_DAY_CLASS + ', .' + OLD_DAY_CLASS + ')')
                                .removeClass(SELECT_CLASS)
                                .filter(function (index) {
                                    return parseInt(this.innerHTML) === d;
                                }).addClass(SELECT_CLASS);
                        };

                    if (type) {
                        var ret = this.updateDateView(y, m, {
                            'old': 'prev',
                            'new': 'next'
                        }[type], toggleClass);
                        y = ret.y;
                        m = ret.m;
                        this.options.viewChange('date', y, m);
                    } else {
                        toggleClass.call(this);
                    }

                    return new Date(y, m - 1, d);
                },
                showLabel: function (event, view, date, data) {
                    var $lbl = this.$label;

                    $lbl.find('p').html(this.options.label.repeat({
                        m: view,
                        d: date.format(this.options.format),
                        v: data
                    }).replace(/\n/g, '<br>'));

                    var w = $lbl.outerWidth(),
                        h = $lbl.outerHeight();

                    $lbl.css({
                        left: (event.pageX - w / 2) + 'px',
                        top: (event.pageY - h - 20) + 'px'
                    }).show();
                },
                hasLabel: function () {
                    if (this.options.label) {
                        $('body').append(this.$label);
                        return true;
                    }
                    return false;
                },
                event: function () {
                    var _this = this,
                        vc = _this.options.viewChange;

                    // view change
                    _this.$element.on('click', DISPLAY_VD, function () {
                        var arr = _this.getDisDateValue();
                        _this.updateMonthView(arr[0], arr[1]);

                        vc('month', arr[0], arr[1]);

                    }).on('click', DISPLAY_VM, function () {
                        var y = this.innerHTML;

                        _this.updateDateView(y);
                        vc('date', y);
                    });

                    // arrow
                    _this.$element.on('click', ARROW_DATE, function () {
                        var arr = _this.getDisDateValue(),
                            type = getClass(this),
                            y = arr[0],
                            m = arr[1];

                        var d = _this.updateDateView(y, m, type, function () {
                            vc('date', d.y, d.m);
                        });

                        var day = new Date(d.y, d.m - 1, d.d);

                        _this.$YMDInput.val(day.format(_this.options.format));
                        _this.$weekDay.text('(' + _this.getWeekDayStr(day) + ')');
                        _this.onValueChange(_this.getDate());

                    }).on('click', ARROW_MONTH, function () {

                        var y = Number(_this.$disMonth.html()),
                            type = getClass(this);

                        y = type === 'prev' ? y - 1 : y + 1;
                        _this.updateMonthView(y);
                        vc('month', y);
                    });

                    // selected
                    _this.$element.on('click', '[' + ITEM_DAY + ']', function () {
                        var d = parseInt(this.innerHTML),
                            cls = getClass(this),
                            type = /new|old/.test(cls) ? cls.match(/new|old/)[0] : '';

                        var day = _this.selectedDay(d, type);

                        _this.options.onSelected.call(this, 'date', day, $(this).data(MARK_DATA));

                        _this.$YMDInput && _this.hide('date', day, $(this).data(MARK_DATA));

                    }).on('click', '[' + ITEM_MONTH + ']', function () {
                        var y = Number(_this.$disMonth.html()),
                            m = parseInt(this.innerHTML);

                        _this.updateDateView(y, m);
                        vc('date', y, m);
                        _this.options.onSelected.call(this, 'month', new Date(y, m - 1));
                    });

                    // hover
                    _this.$element.on('mouseenter', '[' + ITEM_DAY + ']', function (e) {
                        var arr = _this.getDisDateValue(),
                            day = new Date(arr[0], arr[1] - 1, parseInt(this.innerHTML));

                        if (_this.hasLabel && $(this).data(MARK_DATA)) {
                            $('body').append(_this.$label);
                            _this.showLabel(e, 'date', day, $(this).data(MARK_DATA));
                        }

                        _this.options.onMouseEnter.call(this, 'date', day, $(this).data(MARK_DATA));
                    }).on('mouseleave', '[' + ITEM_DAY + ']', function () {
                        _this.$label.hide();
                    });

                    _this.$YMDInput.bind('input propertychange', function () {
                        _this.onValueChange(_this.getDate());
                    });
                    _this.$HMInput.bind('input propertychange', function () {
                        _this.onValueChange(_this.getDate());
                    });
                },
                resize: function () {
                    var w = this.width,
                        h = this.height,
                        hdH = this.$element.find('.pickAdate-hd').outerHeight();

                    this.$element.width(w).height(h + hdH)
                        .find('.pickAdate-inner, .view')
                        .css('width', w + 'px');

                    this.$element.find('.pickAdate-ct').width(w).height(h);

                },
                setData: function (data) {
                    this.data = data;

                    if (this.view === 'date') {
                        var d = this.getDisDateValue();
                        this.fillDateItems(d[0], d[1]);
                    } else if (this.view === 'month') {
                        this.updateMonthView(this.$disMonth.html());
                    }
                },
                methods: function (name, args) {
                    if (OS.call(this[name]) === '[object Function]') {
                        return this[name].apply(this, args);
                    }
                }
            });

            var selectEnd = 4, middleIndex = 2;
            var _timeChooseBox = null;

            function timeChooseBox(container, options) {
                if (!container) {
                    return;
                }
                _timeChooseBox = this;
                this._default = {
                    onkeypress: null,
                    onclick: null,
                    onselect: null,
                    self: null
                };
                this.$el = options.self.$parent.find('#' + container)[0];
                this.$el.onkeypress = this.keyPress;
                this.$el.onclick = this.click;
                this.$el.onselect = this.select;
                this.$el.onkeydown = this.keydown;
                this.$el.onkeyup = this.keyUp;
                this.$el.onpaste = this.preventDefault;
                this.$el.ondragstart = this.preventDefault;
                this.$el.onblur = this.blur;
                this.$el.$options = $.extend({}, this._default, options);
                //this.setTime();
                return this.$el;
            }

            $.extend(timeChooseBox.prototype, {
                setTime: function () {
                    var today = new Date();
                    var hours = today.getHours(), minutes = today.getMinutes();
                    if (minutes > 30) {
                        minutes = "00";
                        if (hours == 23) {
                            hours = 0;
                        } else {
                            hours += 1;
                        }
                    } else {
                        minutes = "30";
                    }
                    hours = ((hours + 100) + "").substr(1, 2);
                    this.$el.value = (hours + ":" + minutes);
                },

                preventDefault: function (e) {
                    return e.preventDefault();
                },

                keyPress: function (e) {
                    if (e.target.selectionStart > selectEnd || e.target.selectionStart == middleIndex || e.keyCode < 48 || e.keyCode > 57) {
                        return e.preventDefault();
                    }
                    _timeChooseBox.proccessKeypress(e, e.keyCode);
                },

                proccessKeypress: function (e, keyCode) {
                    var number = parseInt(String.fromCharCode(keyCode));
                    var selectEnd = e.target.selectionEnd;
                    var selectStart = e.target.selectionStart;
                    var _hour = e.target.value.substring(0, e.target.value.indexOf(':'));
                    if (selectStart == 0 && selectEnd == 0) {
                number >= 2 ? e.preventDefault() | e.target.setSelectionRange(0, e.target.value.indexOf(':')) | e.target.setRangeText('0' + number) | e.target.setSelectionRange(e.target.value.indexOf(':') + 1, e.target.value.length) : _hour.length >= 2 ? e.preventDefault() : true;
            } else if (selectStart == 0 && selectEnd == 1) {
                return number <= 2 && _hour % 10 < 4? true : e.preventDefault() | e.target.setSelectionRange(0, e.target.value.indexOf(':')) | e.target.setRangeText('0' + number);
            } else if (selectStart >= 1 && selectEnd <= 2) {
                var _one = parseInt(e.target.value.substring(0, 1));
                // return  _one >= 2 ? number <= 4 ? (number <= 3 ? true : e.preventDefault()) : e.preventDefault() : true;
                /* */
                if (parseInt(_one) >= 2) {
                    if (number <= 4) {
                        if (number <= 3) {
                            if(_hour.length > 1){
                                e.target.setSelectionRange(1, 2);
                                e.target.setRangeText(number);
                            }
                        }
                        else {
                            e.preventDefault();
                        }
                    }
                    else {
                        e.preventDefault();
                    }
                }
                else {
                    if(_hour.length > 1){
                        e.target.setSelectionRange(1, 2);
                        e.target.setRangeText(number);
                    }
                }

            } else if (selectStart == 0 && selectEnd == 2) {
                return  number > 2 ? e.preventDefault() | e.target.setSelectionRange(0, e.target.value.indexOf(':')) | e.target.setRangeText('0' + number) | e.target.setSelectionRange(e.target.value.indexOf(':') + 1, e.target.value.length) : true;
            } else if (selectStart == 3) {
                if (e.target.value.length ==4) {
                    e.target.value = e.target.value.substr(0, e.target.value.length - 1);
                }
                else if (e.target.value.length ==5) {
                    e.target.value = e.target.value.substr(0, e.target.value.length - 2);
                }
                return number <= 5 ? true : e.target.setRangeText('0' + number) | e.target.setSelectionRange(3, 5) | e.preventDefault();
            }
            else if (selectStart == 4) {
                if (e.target.value.length == 5) {
                    e.target.value = e.target.value.substr(0, e.target.value.length - 1);
                }
            }
            else {
                if ( selectEnd - selectStart >= 4) {
                    return e.preventDefault();
                }
                var _len = e.target.value.substring(e.target.value.indexOf(':') + 1, e.target.value.length + 1);
                if (_len.length > 2) {
                    return e.preventDefault();
                }
            }
        },

                keydown: function (e) {
                    if (e.target.selectionStart == e.target.value.indexOf(':') + 1 && e.keyCode == 8 && e.target.selectionEnd == e.target.value.indexOf(':') + 1) {
                        e.target.setSelectionRange(0, e.target.value.indexOf(':'));
                        e.preventDefault();
                    }
                    if (this.$options.onkeypress)
                        this.$options.onkeypress(this.$options.self);
                },

                keyUp: function (e) {
                    var number = String.fromCharCode(e.keyCode);
                    var _munites = e.target.value.substring(e.target.value.indexOf(':') + 1, e.target.value.length + 1);
                    var hasSplit = e.target.value.indexOf(':') >= 0 ? true : false;
                    if (e.target.selectionStart == middleIndex && e.keyCode != 37 && e.keyCode != 39 && e.keyCode != 8) {

                        if (hasSplit) {
                            e.target.setSelectionRange(3, 5);
                            return;
                        }
                        e.target.setRangeText(':');
                        e.target.selectionStart = 3;
                        return;
                    } else {
                        if (e.target.value.indexOf(':') == -1) {
                            e.target.setRangeText(':');
                        }
                    }

                    if (e.keyCode == 39 && e.target.selectionStart > e.target.value.indexOf(':')) {
                        var _preNum = parseInt(e.target.value.substring(0, e.target.value.indexOf(':')));
                        var _nextNum = e.target.value.substring(e.target.value.indexOf(':'), e.target.value.length + 1);
                        _preNum < 10 ? e.target.value = '0' + _preNum + _nextNum : true;
                        e.target.selectionStart = e.target.value.indexOf(':') + 1;
                    }

                    if (e.keyCode == 37 && e.target.selectionStart < e.target.value.indexOf(':') + 1) {
                        var _preNum = e.target.value.substring(0, e.target.value.indexOf(':') + 1);
                        var _nextNum = parseInt(e.target.value.substring(e.target.value.indexOf(':') + 1, e.target.value.length + 1));
                        _nextNum < 6 ? e.target.value = _preNum + _nextNum + '0' : true;
                        e.target.selectionEnd = e.target.value.indexOf(':');
                    }
                },

                click: function (e) {
                    e.target.selectionStart <= middleIndex ?
                        e.target.setSelectionRange(0, e.target.value.indexOf(':') >= 0 ?
                            e.target.value.indexOf(':') : 1) : e.target.setSelectionRange(e.target.value.indexOf(':') + 1, 5);
                    if (e.target.selectionStart == middleIndex) {
                        //e.target.setSelectionRange(0, 2);
                        return;
                    }
                    if (this.$options.onclick)
                        this.$options.onclick(e.target.value, e.target.selectionStart, e.target.selectionEnd, this.$options.self);

                },

                select: function (e) {
                    this.selectStart = e.target.selectionStart;
                    if (e.target.selectionStart == middleIndex) {
                        return e.preventDefault();
                    }
                },

                blur: function (e) {
                    var _value = $(this).val();
                    var _middle = e.target.value.indexOf(':');
                    var _preNum = _middle >= 0 ? _value.substring(0, _middle) : _value.substring(0, 2);
                    var _preNext = _middle >= 0 ? _value.substring(_middle + 1, _value.length + 1) : '00';
                    $(this).val((_preNum ? _preNum.length <= 1 ? '0' + _preNum : _preNum : '00') + ':' + (_preNext ? _preNext.length <= 1 ? '0' + _preNext : _preNext : '00'));
                }
            });

            $scope.datePicker = new pickDate(element.find('.start-time'), true, true, function (value) {
                if(value){
                    utils.applyScope($scope,function(){
                        $scope.noNeedUpdate = true;
                        $scope.date = value.getTime();
                    });
                }
            });

            var stopWatchDate = $scope.$watch('date',function(newV,oldV){
                if(newV && !$scope.noNeedUpdate){
                    $scope.datePicker.setDate(new Date(newV));
                }
            });

            $scope.$on('$destroy',function(){
                stopWatchDate();
            });
        }
    }
}]);